#ifndef CE2_ECPKI_DH_H
#define CE2_ECPKI_DH_H

/*
 *  Object name     :  CE2_ECPKI_DH.h
 *  State           :  %state%
 *  Creation date   :  02.02.2006
 *  Last modified   :  %modify_time%
 */
/** @file CE2_ECPKI_DH.h
 * \brief Defines the API that supports EC Diffie-Hellman
 *        shared secret value derivation primitives
 *
 * \version CE2_ECPKI_DH.h #1:incl:1
 * \author R.Levin
 * \remarks Copyright (C) 2006 by Discretix Technologies Ltd. All rights reserved.
 */

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**
****************************************************************
* Function Name: 
*  CE2_ECDH_SVDP_DH
*
* Inputs:
* @param BuildedPartnerPublKey_ptr [in] - A pointer to a partner public key. 
* @param UserPrivKey_ptr [in] - A pointer to a user private key.
* @param SharedSecretValue_ptr [out] - A pointer to an output buffer that will 
*                          contain the shared secret value.
* @param SharedSecrValSize_ptr [in\out] - A pointer to the size of user passed 
*                          buffer (in) and actual output size of 
*                          calculated shared secret value.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_ECPKI_SVDP_DH_INVALID_BUILDED_PARTNER_PUBLIC_KEY_PTR_ERROR
*   - CE2_ECPKI_SVDP_DH_INVALID_USER_PRIVATE_KEY_PTR_ERROR
*   - CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_PTR_ERROR
*   - CE2_ECPKI_SVDP_DH_INVALID_SHARED_SECRET_VALUE_SIZE_PTR_ERROR
*   - CE2_ECPKI_SVDP_DH_INVALID_DOMAIN_ID_ERROR
*
* \brief \b 
* Description:
*  Creates the shared secret value accordingly to the IEEE 1363-2000 
*  standard.
*
* \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_ECDH_SVDP_DH 
*     for creation of shared secret with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_ECDH_SVDP_DH( 
						CE2_ECPKI_UserPublKey_t *BuildedPartnerPublKey_ptr, /*in*/
						CE2_ECPKI_UserPrivKey_t *UserPrivKey_ptr,           /*in*/							                
						DxUint8_t		 *SharedSecretValue_ptr,     /*out*/
						DxUint32_t               *SharedSecrValSize_ptr    /*in/out*/);



#ifdef __cplusplus
}
#endif			

#endif
